/*! \file 
**********************************************************************************
*Title:                         Discretix OMA DRM v2 Toolkit source file
*
* Filename:                     tlk_odrm_llf_version_host.c
*
* Project, Target, subsystem:   Toolkit, OMA DRM
* 
* Created:                      26.12.2007
*
* Modified:                     26.12.2007
*
* \Author                       Ira Boguslavsky
*
* \Remarks
*           Copyright (C) 2007 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/

#include "DX_VOS_BaseTypes.h"

#include "SEPDriver.h"

#include "tlk_odrm_def.h"
#include "tlk_odrm_types.h"
#include "tlk_odrm_errors.h"
#include "tlk_odrm_version.h"
#include "tlk_odrm_host_op_code.h"
#include "error.h"


#ifdef TLK_ODRM_SEP_SIMULATOR
    #include "tlk_odrm_llf_version_duplicate_wrapper.h"
    #define TLK_ODRM_START_OFFSET                       0x8
#else
    #define TLK_ODRM_START_OFFSET                       0x0
#endif

DxError_t TLK_ODRM_LLF_VersionGet( TLK_ODRMVersion_t *aVersion_ptr)
{
    DxError_t    error;
    DxUint32_t   sramOffset = TLK_ODRM_START_OFFSET;        /* offset into SRAM */

    DxUint32_t   paramInBuffer[DX_2_WORDS_PARAMS];
    DxUint32_t   paramOutBuffer[DX_2_WORDS_PARAMS];

    if(TLK_ODRM_IS_NULL_PARAM(aVersion_ptr))
    {
        return TLK_ODRM_RC_ERROR_NULL_POINTER;
    }

    /************************************************************************/
    /*  Lock access to SEP                                                  */
    /************************************************************************/
    SEPDriver_Lock();

    /************************************************************************/
    /* Start sending message to SeP */
    SEPDriver_StartMessage(&sramOffset);
    
    paramInBuffer[0] = TLK_ODRM_VERSION_MSG_OP_CODE;

    error = SEPDriver_WriteParamater((DxUint32_t)paramInBuffer,
                                      sizeof(DxUint32_t) * DX_1_WORD_PARAMS,
                                      sizeof(DxUint32_t) * DX_1_WORD_PARAMS,
                                     &sramOffset,
                                      DX_FALSE);
    if(error != DX_SUCCESS)
    {
        goto end_function_unlock;
    }

    /************************************************************************/
    /* End message                                                          */
    /************************************************************************/
    SEPDriver_EndMessage(sramOffset);


    /************************************************************************/
    /* Wait for the response                                                */
    /************************************************************************/
    error = SEPDriver_POLL_FOR_REPONSE();
    if(error != DX_SUCCESS)
    {
        goto end_function_unlock;
    }

    /************************************************************************/
    /* Start reading message from the SEP                                   */
    /************************************************************************/
    /* Start the message */
    error = SEPDriver_StartIncomingMessage(&sramOffset);
    if(error)
    {
        goto end_function_unlock;
    }

    /* Read opcode + status  */
    error = SEPDriver_ReadParamater((DxUint32_t)paramOutBuffer,
                                     sizeof(DxUint32_t) * 2,
                                     sizeof(DxUint32_t) * 2,
                                    &sramOffset ,
                                     DX_FALSE);
    if(error != DX_SUCCESS)
    {
        goto end_function_unlock;
    }

    /* check the opcode */
    if(paramOutBuffer[0] != TLK_ODRM_VERSION_MSG_OP_CODE)
    {
        error = DX_WRONG_OPCODE_FROM_SEP_ERR;
        goto end_function_unlock;
    }

    /* check the status */
    if(paramOutBuffer[1] != CRYS_OK)
    {
        error = paramOutBuffer[1];
        goto end_function_unlock;
    }

    /* Read opcode + status  */
    error = SEPDriver_ReadParamater((DxUint32_t)aVersion_ptr,
                                    sizeof(TLK_ODRMVersion_t),
                                    sizeof(TLK_ODRMVersion_t),
                                   &sramOffset ,
                                    DX_FALSE);
    if(error != DX_SUCCESS)
    {
        goto end_function_unlock;
    }


end_function_unlock:   

    /* lock access to the SEP */
    SEPDriver_Unlock();

    return TLK_ODRM_RC_OK;
}
